// Sega Genesis GYM music file emulator

// Game_Music_Emu 0.4.0
#ifndef GYM_EMU_H
#define GYM_EMU_H

#include "Dual_Resampler.h"
#include "Ym2612_Emu.h"
#include "Music_Emu.h"
#include "Sms_Apu.h"

class Gym_Emu : public Music_Emu, private Dual_Resampler {
public:
	// GYM file header
	struct header_t
	{
	    char tag [4];
	    char song [32];
	    char game [32];
	    char copyright [32];
	    char emulator [32];
	    char dumper [32];
	    char comment [256];
	    byte loop_start [4]; // in 1/60 seconds, 0 if not looped
	    byte packed [4];
	};
	BOOST_STATIC_ASSERT( sizeof (header_t) == 428 );
	
	// Load GYM data
	blargg_err_t load( Data_Reader& );
	
	// Load GYM file using already-loaded header and remaining data
	blargg_err_t load( header_t const&, Data_Reader& );
	
	// Load GYM using pointer to file data. Keeps pointer to data rather than copying it.
	blargg_err_t load( void const* data, long size );
	
	// Header for currently loaded GYM (cleared to zero if GYM lacks header)
	header_t const& header() const { return header_; }
	
	// Length of track data in 1/60 seconds
	enum { gym_rate = 60 }; // GYM time units (frames) per second
	long track_length() const;

	// Read track info without loading into emulator
	static blargg_err_t read_info( Data_Reader& in, track_info_t* out, int = 0 );
	
public:
	typedef Music_Emu::sample_t sample_t;
	Gym_Emu();
	~Gym_Emu();
	void mute_voices( int );
	const char** voice_names() const;
	Music_Emu::track_info;
	blargg_err_t track_info( track_info_t*, int track ) const;
protected:
	void start_track_( int );
	int play_frame( blip_time_t blip_time, int sample_count, sample_t* buf );
	blargg_err_t set_sample_rate_( long sample_rate );
	void play_( long count, sample_t* );
private:
	// sequence data begin, loop begin, current position, end
	const byte* data;
	const byte* loop_begin;
	const byte* pos;
	const byte* data_end;
	long loop_remain; // frames remaining until loop beginning has been located
	blargg_vector<byte> mem;
	header_t header_;
	blargg_err_t load_( const void* file, long data_offset, long file_size );
	void parse_frame();
	void unload();
	
	// dac (pcm)
	int dac_amp;
	int prev_dac_count;
	bool dac_enabled;
	bool dac_muted;
	void run_dac( int );
	
	// sound
	Blip_Buffer blip_buf;
	Ym2612_Emu fm;
	Blip_Synth<blip_med_quality,1> dac_synth;
	Sms_Apu apu;
	byte dac_buf [1024];
};

#endif
